/*

Ringo Robot
Ringo_ProductionTest_02
Version 2.0 7/2015

This is a basic sketch that can be used as a starting point
for various functionality of the Ringo robot.

This sketch was written by Kevin King for Plum Geek LLC with 
significant portions written by Dustin Soodak.
This code is completely free for any use.
Visit http://www.plumgeek.com for Ringo information.
Visit http://www.arduino.cc to learn about the Arduino.

*/


#include "MiscHardware.h"
#include "Navigation.h"

#define LSLowers_LowThresh 190
#define LSLowers_HighThresh 800
#define IRSendTestDelay 200
#define PixelFlashDelay 100

void setup(){
  HardwareBegin();        //initialize Ringo's brain to work with his circuitry
  //PlayStartChirp();       //Play startup chirp and blink eyes
  
  //delay(1000);//make sure not moving robot when NavigationBegin() since it also zeroes the sensors
  //NavigationBegin();//initialize and start navigation
  RestartTimer();
  
}

void getLedColorHSV(int h, double s, double v);
void TestTopLightSensors(void);
void TestBottomLightSensors(void);
void TestNeoPixels(void);
void midChirp(void);
void Test38kHzRx(void);
void DriveSquare(void);

int sensorLeft, sensorRight, sensorRear;
int hueLeft, hueRight, hueRear;
int red, green, blue;

void loop(){ 
  
  TestNeoPixels();
  TestIRSenders();
  Test38kHzRx();
  TestTopLightSensors();
  TestBottomLightSensors();
  DriveSquare();
  
  delay(10000);

}

void DriveSquare(){
  
  int offset=-5;
  delay(1000);                // time to get fingers off the robot
  ZeroNavigation();
  NavigationBegin();
  
  SwitchButtonToPixels();
  SetAllPixelsRGB(0,0,0);
  SetPixelRGB(4,0,50,0);SetPixelRGB(5,0,50,0);RefreshPixels();
  
  SwitchSerialToMotors();     // make sure we're setup to run the motors
  
  for(byte i=0;i<8;i++){
    //MoveWithOptions(5, 150, 60, 3000, 1000, 0);
    MoveWithOptions(0, 150, 60, 5000, 1000, 0,0);
    //MoveStraight(1, 100, 150, 1000, 50);
    delay(100);
    RotateAccurate(90,1000);//exact rotation
    delay(100);
    //RotateSimple(offset-GetDegrees(), 150, -150, 1000, 250);//approximate rotation
  }
  MoveWithOptions(0, 250, 120, 5000, 1000, 0,0);
  //MoveStraight(1, 100, 150, 1000, 50);
  SetAllPixelsRGB(0,0,0);
}

void TestNeoPixels(){
 
  SwitchButtonToPixels();
  
  for(byte i=0; i<12; i++){
     SetAllPixelsRGB(0,0,0);              // shut off all pixels
     delay(PixelFlashDelay);
     SetAllPixelsRGB(50,50,50);
     delay(PixelFlashDelay);     
   }
  PlayExcited();
  
}



void Test38kHzRx(){

//byte i;  //used in for loops
SwitchButtonToPixels();
SetAllPixelsRGB(0,0,0);              // shut off all pixels

  while(1){
  
  digitalWrite(IR_Send, LOW);
  digitalWrite(IR_Enable_Front, HIGH);
  digitalWrite(IR_Enable_RearLeft, LOW);
  digitalWrite(IR_Enable_RearRight, LOW);
   
   PlayChirpIR(38000, 5);  // turn on 38 kHz carrier
   
   for(byte i=0; i<10; i++){
     if (!digitalRead(_38kHz_Rx)){    // if the 38 kHz Rx line is low (receiving 38 kHz carrier)
     SetPixelRGB(0,25,0,25);              // mark with pixel blink
     RefreshPixels();
     }
     else
     {
     SetPixelRGB(0,0,0,0);              // mark with pixel blink
     RefreshPixels();  
     }
   }
   
   PlayChirpIR(0, 0);  // turn off 38 kHz carrier
   
   for(byte x=0; x<250; x++){
     if (!digitalRead(_38kHz_Rx)){    // if the 38 kHz Rx line is low (receiving 38 kHz carrier)
     SetPixelRGB(0,25,0,25);              // mark with pixel blink
     RefreshPixels();
     }
     else
     {
     SetPixelRGB(0,0,0,0);              // mark with pixel blink
     RefreshPixels();  
     }
   }
      
   //delay(2);
  
    // check button
    pinMode(Light_Bus_BTN1,INPUT_PULLUP);
    if(!digitalRead(Light_Bus_BTN1)){
        midChirp();
        delay(10);
        while(!digitalRead(Light_Bus_BTN1)){ // wait for button release
        delay(1);
        }
      delay(10);    // debounce
      digitalWrite(Light_Bus_BTN1, LOW);  // switch button back to pixels
      pinMode(Light_Bus_BTN1,OUTPUT);
      SetAllPixelsRGB(0,0,0);
      digitalWrite(IR_Send, LOW);              // make sure IR senders aren't latched on
      digitalWrite(IR_Enable_Front, LOW);      // make sure IR senders aren't latched on
      digitalWrite(IR_Enable_RearLeft, LOW);   // make sure IR senders aren't latched on
      digitalWrite(IR_Enable_RearRight, LOW);  // make sure IR senders aren't latched on
      break;
      }
    digitalWrite(Light_Bus_BTN1, LOW);
    pinMode(Light_Bus_BTN1,OUTPUT);
    // end check button
    
  }
}



void TestIRSenders(){

SwitchButtonToPixels();

  while(1){
  
  digitalWrite(IR_Send, LOW);
  
  digitalWrite(IR_Enable_Front, HIGH);  // enable nose IR
  digitalWrite(IR_Send, HIGH);          // send it
  SetPixelRGB(3,10,10,30);              // mark with pixel blink
  RefreshPixels();
  
  //delay(5000);
  delay(IRSendTestDelay);              // delay to test this sender
  
  digitalWrite(IR_Send, LOW);          // stop it
  digitalWrite(IR_Enable_Front, LOW);  // disable nose IR
  SetAllPixelsRGB(0,0,0);              // shut off mark pixel
  
  digitalWrite(IR_Enable_RearRight, HIGH);  // enable Rear Right IR
  digitalWrite(IR_Send, HIGH);          // send it
  
  delay(IRSendTestDelay);              // delay to test this sender
  
  digitalWrite(IR_Send, LOW);          // stop it
  digitalWrite(IR_Enable_RearRight, LOW);  // disable Rear Right IR
  
  digitalWrite(IR_Enable_RearLeft, HIGH);  // enable Rear Left IR
  digitalWrite(IR_Send, HIGH);          // send it
  
  delay(IRSendTestDelay);              // delay to test this sender
  
  digitalWrite(IR_Send, LOW);          // stop it
  digitalWrite(IR_Enable_RearLeft, LOW);  // disable Rear Left IR
  //delay(100);
  
    // check button
    pinMode(Light_Bus_BTN1,INPUT_PULLUP);
    if(!digitalRead(Light_Bus_BTN1)){
        midChirp();
        delay(10);
        while(!digitalRead(Light_Bus_BTN1)){ // wait for button release
        delay(1);
        }
      delay(10);    // debounce
      digitalWrite(Light_Bus_BTN1, LOW);  // switch button back to pixels
      pinMode(Light_Bus_BTN1,OUTPUT);
      SetAllPixelsRGB(0,0,0);
      digitalWrite(IR_Send, LOW);              // make sure IR senders aren't latched on
      digitalWrite(IR_Enable_Front, LOW);      // make sure IR senders aren't latched on
      digitalWrite(IR_Enable_RearLeft, LOW);   // make sure IR senders aren't latched on
      digitalWrite(IR_Enable_RearRight, LOW);  // make sure IR senders aren't latched on
      break;
      }
    digitalWrite(Light_Bus_BTN1, LOW);
    pinMode(Light_Bus_BTN1,OUTPUT);
    // end check button
    
  }
}


void TestBottomLightSensors(){
  
int on, off, diff, then, now;
int leftOn, leftOff, rightOn, rightOff, rearOn, rearOff;
int leftDiff, rightDiff, rearDiff;
digitalWrite(Source_Select, LOW);
SwitchButtonToPixels();

  while(1){
  //digitalWrite(Light_Bus_BTN1, LOW);
  //pinMode(Light_Bus_BTN1,OUTPUT);
  //SetAllPixelsRGB(0,0,0);                    // turn off all pixels
  //delay(1);                                  // let sensors relax
  
  digitalWrite(Edge_Lights, HIGH);
  delay(2);
  leftOn = analogRead(LightSense_Left);
  rightOn = analogRead(LightSense_Right);
  rearOn = analogRead(LightSense_Rear);
 
  digitalWrite(Edge_Lights, LOW);
  delay(2);
  leftOff = analogRead(LightSense_Left);
  rightOff = analogRead(LightSense_Right);
  rearOff = analogRead(LightSense_Rear);
 
  leftDiff = leftOn-leftOff;
  rightDiff = rightOn-rightOff;
  rearDiff = rearOn-rearOff;
  
  Serial.print(leftOn);
  Serial.print("  ");
  Serial.print(leftDiff);
  Serial.print("    ");
 
  Serial.print(rightOn);
  Serial.print("  ");
  Serial.print(rightDiff);
  Serial.print("    ");
 
  Serial.print(rearOn);
  Serial.print("  ");
  Serial.print(rearDiff);
  Serial.println();

  if(leftDiff <= LSLowers_LowThresh){         // left sensor
    SetPixelRGB(5,50,0,0);
  }
  else if (leftDiff >= LSLowers_HighThresh){
    SetPixelRGB(5,0,50,0);
  }      
  else {
    SetPixelRGB(5,0,0,0);
  }
  
  if(rightDiff <= LSLowers_LowThresh){        // right sensor
    SetPixelRGB(4,50,0,0);
  }
  else if (rightDiff >= LSLowers_HighThresh){
    SetPixelRGB(4,0,50,0);
  }      
  else {
    SetPixelRGB(4,0,0,0);
  }
  
  if(rearDiff <= LSLowers_LowThresh){        // rear sensor
    SetPixelRGB(0,50,0,0);
  }
  else if (rearDiff >= LSLowers_HighThresh){
    SetPixelRGB(0,0,50,0);
  }      
  else {
    SetPixelRGB(0,0,0,0);
  }
  
  RefreshPixels();
    
  delay(100);
  
    // check button
    pinMode(Light_Bus_BTN1,INPUT_PULLUP);
    if(!digitalRead(Light_Bus_BTN1)){
        midChirp();
        delay(10);
        while(!digitalRead(Light_Bus_BTN1)){ // wait for button release
        delay(1);
        }
      delay(10);    // debounce
      digitalWrite(Light_Bus_BTN1, LOW);  // switch button back to pixels
      pinMode(Light_Bus_BTN1,OUTPUT);
      SetAllPixelsRGB(0,0,0);
      break;
      }
    digitalWrite(Light_Bus_BTN1, LOW);
    pinMode(Light_Bus_BTN1,OUTPUT);
    // end check button
    
  }
}


void TestTopLightSensors(){
  
  while(1){
  digitalWrite(Source_Select, HIGH);
  SetAllPixelsRGB(0,0,0);                    // turn off all pixels
  delay(1);                                  // let sensors relax
  
  sensorLeft = analogRead(LightSense_Left);  //read left light sensor
  sensorRight = analogRead(LightSense_Right);  //read right light sensor
  sensorRear = analogRead(LightSense_Rear);  //read rear light sensor
  
  hueLeft = sensorLeft/3;
  hueRight = sensorRight/3;
  hueRear = sensorRear/3;
  
  getLedColorHSV(hueLeft,1,1);
  SetPixelRGB(4,red,green,blue); // place value on left pixel
  getLedColorHSV(hueRight,1,1);
  SetPixelRGB(5,red,green,blue); // place value on right pixel
  getLedColorHSV(hueRear,1,1);
  SetPixelRGB(3,red,green,blue); // place value on rear pixel
  RefreshPixels();               // update the pixels
  
  delay(100);
  
    // check button
    pinMode(Light_Bus_BTN1,INPUT_PULLUP);
    if(!digitalRead(Light_Bus_BTN1)){
        midChirp();
        delay(10);
        while(!digitalRead(Light_Bus_BTN1)){ // wait for button release
        delay(1);
        }
      delay(10);    // debounce
      digitalWrite(Light_Bus_BTN1, LOW);  // switch button back to pixels
      pinMode(Light_Bus_BTN1,OUTPUT);
      SetAllPixelsRGB(0,0,0);
      break;
      }
    digitalWrite(Light_Bus_BTN1, LOW);
    pinMode(Light_Bus_BTN1,OUTPUT);
    // end check button
    
  }
}



// ***************************************************
// Supporting Functions
// ***************************************************

void midChirp(void){
  PlayChirp(2000, 50);
  delay(100);
  PlayChirp(0, 0); 
}

//Convert a given HSV (Hue Saturation Value) to RGB(Red Green Blue) and set the led to the color
//  h is hue value, integer between 0 and 360
//  s is saturation value, double between 0 and 1
//  v is value, double between 0 and 1
//http://splinter.com.au/blog/?p=29
void getLedColorHSV(int h, double s, double v) {
  //this is the algorithm to convert from RGB to HSV
  double r=0; 
  double g=0; 
  double b=0;

  double hf=h/60.0;

  int i=(int)floor(h/60.0);
  double f = h/60.0 - i;
  double pv = v * (1 - s);
  double qv = v * (1 - s*f);
  double tv = v * (1 - s * (1 - f));

  switch (i)
  {
  case 0: //rojo dominante
    r = v;
    g = tv;
    b = pv;
    break;
  case 1: //verde
    r = qv;
    g = v;
    b = pv;
    break;
  case 2: 
    r = pv;
    g = v;
    b = tv;
    break;
  case 3: //azul
    r = pv;
    g = qv;
    b = v;
    break;
  case 4:
    r = tv;
    g = pv;
    b = v;
    break;
  case 5: //rojo
    r = v;
    g = pv;
    b = qv;
    break;
  }

  //set each component to a integer value between 0 and 255
  red=constrain((int)255*r,0,255);
  red=red/4;
  green=constrain((int)255*g,0,255);
  green=green/4;
  blue=constrain((int)255*b,0,255);
  blue=blue/4;
  //setLedColor(red,green,blue);
}




